texture DiffuseMap;
texture ResampleMap;
texture ResampleToLumMap;
texture LastLumMap;
texture LumMap;
texture AvgMap;
texture AdaptAvgMap;
texture StarMap;
texture Rays;
texture Glow;

texture StarMap0;
texture StarMap1;
texture StarMap2;
texture StarMap3;
texture StarMap4;
texture StarMap5;

sampler sDiffuseMap = 
sampler_state{
	Texture = <DiffuseMap>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sRays = 
sampler_state{
	Texture = <Rays>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = CLAMP;
    AddressV  = CLAMP;
};

sampler sGlow = 
sampler_state{
	Texture = <Glow>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sStarMap = 
sampler_state{
	Texture = <StarMap>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sStarMap0 = 
sampler_state{
	Texture = <StarMap0>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sStarMap1 = 
sampler_state{
	Texture = <StarMap1>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sStarMap2 = 
sampler_state{
	Texture = <StarMap2>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sStarMap3 = 
sampler_state{
	Texture = <StarMap3>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sStarMap4 = 
sampler_state{
	Texture = <StarMap4>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sStarMap5 = 
sampler_state{
	Texture = <StarMap5>;
	MinFilter = ANISOTROPIC;  
    MagFilter = LINEAR;
    MipFilter = NONE;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sResampleMap = 
sampler_state{
	Texture = <ResampleMap>;
	MinFilter = LINEAR;  
    MagFilter = LINEAR;
    MipFilter = None;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sResampleToLumMap = 
sampler_state{
	Texture = <ResampleToLumMap>;
	MinFilter = POINT;  
    MagFilter = POINT;
    MipFilter = None;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sLastLumMap = 
sampler_state{
	Texture = <LastLumMap>;
	MinFilter = POINT;  
    MagFilter = POINT;
    MipFilter = None;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sLumMap = 
sampler_state{
	Texture = <LumMap>;
	MinFilter = LINEAR;  
    MagFilter = LINEAR;
    MipFilter = None;
    AddressU  = Clamp;
    AddressV  = Clamp;
};

sampler sAvgMap = 
sampler_state{
	Texture = <AvgMap>;
	MinFilter = POINT;  
    MagFilter = POINT;
    MipFilter = None;
    AddressU  = Wrap;
    AddressV  = Wrap;
};

sampler sAdaptAvgMap = 
sampler_state{
	Texture = <AdaptAvgMap>;
	MinFilter = POINT;  
    MagFilter = POINT;
    MipFilter = None;
    AddressU  = Wrap;
    AddressV  = Wrap;
};

float widthTX;
float heightTX; 
float time;
float2 offsets[8];
float3 weights[8];
float4x4 matSun;
float4 LightPos;
float4 SunColor;
float SunPower;

float glowRadius;
float3 SUN_SHIFT;
float minL;
float maxL;
float sunMagn;
float blurMagn;
float aTime;
float level;
float bLevel;

float overcast;

const float3 LUM = {0.2125, 0.7154, 0.0721};

////////////////////
// Helper function {0.2125, 0.7154, 0.0721};
////////////////////

float3 resample4x4(sampler Map, float2 uv){
	float dx = 1.0 / widthTX;
	float dy = 1.0 / heightTX;
	
	float3 sample = float3(0, 0, 0);
	
	for(int y = 0; y < 4; y++)
		for(int x = 0; x < 4; x++){
			float2 duv = float2((x - 1.5f) * dx, (y - 1.5f) * dy);
			sample += tex2D(Map, duv + uv).rgb;
	}
	
	sample /= 16;
//default: sample /= 16;  less= stronger HDR 
	return sample;
}

float3 resample2x2(sampler Map, float2 uv){
	const float2 du = {1.5 / widthTX, 0.0};
	const float2 dv = {0.0, 1.5 / heightTX};
	
	float3 sample = tex2D(Map, uv).rgb +
        			tex2D(Map, uv + du).rgb +
					tex2D(Map, uv + dv).rgb +
					tex2D(Map, uv + du + dv).rgb;
					
	sample *= 0.25;
//default: sample *= 0.25;	
	return sample;
}

////////////////////

struct vAP_Input{
	float3 vPosition	:POSITION;
	float2 vTexCoords	:TEXCOORD0;
}; 

struct vAP_Output{
	float4 vPosition	:POSITION;
	float3 vTexCoords	:TEXCOORD0;
};

vAP_Output vsMain(const vAP_Input v){
	vAP_Output res;
	
	res.vPosition = float4(v.vPosition, 1.0);
	res.vTexCoords = float3(v.vTexCoords, v.vPosition.x);
	
	return res;
}

float4 FakeHDRPass(const vAP_Output v): COLOR0{
	float3 diffuse = tex2D(sDiffuseMap, v.vTexCoords.xy).rgb;
	diffuse = pow(max(0.0, dot(diffuse, LUM)), 32.0) * 2.0 + diffuse;
	return float4(diffuse, 1.0);
}


float4 psMain(const vAP_Output v): COLOR0 {
	const float2 duv = {0.5 / widthTX, 0.5 / heightTX};
	
	float3 diffuse = tex2D(sDiffuseMap, v.vTexCoords.xy).rgb;
	float3 blur = tex2D(sResampleMap, v.vTexCoords.xy).rgb;
	float2 lum = tex2D(sAdaptAvgMap, float2(0.5, 0.5)).rg;
	//float3 star = tex2D(sStarMap, v.vTexCoords.xy).rgb;
	float3 sStar = float3(1, 1, 1);
	
	float2 lp = LightPos.xy / LightPos.w;
	
	float2 wUV = (v.vTexCoords.xy - 0.5) * 2.0;
	wUV.y =- wUV.y;
	float lGlow = clamp(1.0 - distance(wUV, lp) / glowRadius, 0.0, 1.0);
	// position of the sunglare
	float aspect = widthTX / heightTX;
	lp.x = -lp.x;
	lp.xy = lp.xy * 0.5;  
	float2 lightUV;
	lightUV.y = lp.y + v.vTexCoords.y;
	lightUV.x = (lp.x + v.vTexCoords.x) * aspect - (aspect * 0.5 - 0.5);
	
	float4 rays = tex2D(sRays, lightUV);
	float3 glow = tex2D(sGlow, lightUV) / 1.0;
	float2 sunPUV = LightPos.xy / LightPos.w;
	sunPUV.y = -sunPUV.y;
	sunPUV = sunPUV * 0.5 + 0.5;
	float sunP = tex2D(sResampleMap, sunPUV);
	sunP = saturate(sunP - 1.0);
	
	float I = clamp(lum.x, minL, maxL);
	float l = saturate(dot(LUM, diffuse));
	float gVal = saturate(lum.y - 0.8) * 4.0 * clamp(SunPower, 0.1, 1.0);
	
	if(LightPos.w < 0){ 
		lGlow = 0.0;
		//star = float3(0.0, 0.0, 0.0);
		glow = float3(0.0, 0.0, 0.0);
		rays.rgba = float4(0.0, 0.0, 0.0, 0.0);
	}
	
	float3 O_SHIFT = float3(1.5, 1.39, 1);
	float3 color = SunColor * O_SHIFT;
	
	float3 BLUE_SHIFT = SUN_SHIFT;
	
	//if(isinf(lum.y)) lum.y = 1.0;
	float mask = clamp(lGlow * pow(abs(1), glowRadius), 0.0, 0.6) * 0.8 * (1.0 - clamp(SunPower, 0.6, 1.0));
	
	float isOvercast = ((overcast - 0.5) * 2.0);
	
		
	float3 composite = diffuse.rgb;
	
#ifdef HARD
	//composite = lerp(diffuse * 1.3, l * BLUE_SHIFT, 0.2) / I;
	composite = lerp(diffuse, diffuse * l + diffuse * 0.6, SunPower * 0.7) / I;
	composite = composite + (color * sunP * rays.rgb * rays.a + color * mask * 0.5) * isOvercast;
	composite = composite + blur * isOvercast * 2.0;
	
	float OV = min(overcast + 0.4, 1.0);
	return float4(composite * OV * 0.95, 1.0);
#endif

#ifdef NORMAL
	composite = lerp(diffuse * 1.2, l * BLUE_SHIFT, 0.25) / I;
	composite = composite + (color * mask + blur * mask * 2.0 / I) * isOvercast;
	composite = composite + color * sunP * rays.rgb * isOvercast * rays.a / clamp(lum.x, 1.0, 2.0);
	composite = composite + blur;	
	
	float OV = min(overcast + 0.4, 1.0);
	return float4(composite * OV * 0.90, 1.0);
#endif

#ifdef SOFT
	composite = lerp(diffuse * 0.75, BLUE_SHIFT * l, bLevel * 0.9) / I;
	composite = composite + (color * mask + blur * mask * 2.0 / I) * isOvercast;
	composite = composite + color * sunP * rays.rgb * isOvercast * rays.a / clamp(lum.x, 1.0, 2.0);
	composite = composite + blur * blurMagn;	
	
	float OV = min(overcast + 0.4, 1.0);
	return float4(composite * OV * 0.90, 1.0);
#endif

	return float4(composite , 1.0);
			
}

///////////////////////////////////////
// Resample pass (down filter 4x4)
// resample scene

float4 ResampleScene4x4(const vAP_Output v): COLOR0{
	float3 sample = resample4x4(sDiffuseMap, v.vTexCoords.xy);
	return float4(sample, 1.0);
}

////////////////////////////////////////////

////////////////////////////////////////////
// Resample scene to lum

float4 ResampleToLum4x4(const vAP_Output v): COLOR0{
	const float2 duv = {0.5 / widthTX, 0.5 / heightTX};
	float3 sample = tex2D(sResampleMap, v.vTexCoords.xy + duv);
	float L = dot(sample, sample);
	return float4(L, L, L, L);
}

/////////////////////////////////////////////

float4 ResampleLum4x4(const vAP_Output v): COLOR0{
	float3 sample = resample4x4(sLumMap, v.vTexCoords.xy).r;
	return float4(sample, 1.0);
}

float4 ResampleLum2x2(const vAP_Output v): COLOR{
	float3 sample = resample2x2(sLumMap, v.vTexCoords.xy);
	return float4(sample, 1.0);
}


float4 AdaptationPS(const vAP_Output v): COLOR0{
	float newLum = tex2D(sAvgMap, float2(0.5, 0.5)); //default: 0.5, 0.5
	float curLum = tex2D(sAdaptAvgMap, float2(0.4, 0.4)); //default: 0.5, 0.5
		
	float T = aTime;
	if(newLum > curLum) T = aTime - 10.0;
	
	float A = curLum + (newLum - curLum) * (1.0 - pow(0.98f, T * time));
	float B = saturate(newLum);
	return float4(A, B, B, B); // default : A, B, B, B
}

float4 BlurX_gauss(const vAP_Output v): COLOR0{
	float2 tx = v.vTexCoords.xy;
	float X = widthTX / 0.52;
    float2 dx  = float2(1.0 / X, 0.0);
    float2 sdx = dx;
    
    float3 sum = tex2D(sResampleMap, tx).rgb * 0.134598;
		
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.127325;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.107778;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.081638;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.055335;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.033562;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.018216;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx ).rgb)* 0.008847;
    sdx += dx;;
    
    return float4(sum, 1.0);
}

float4 BlurY_gauss(const vAP_Output v): COLOR0{
	float2 tx = v.vTexCoords.xy;
	float Y = heightTX / 0.52;
    float2 dx  = float2(0.0, 1.0 / Y);
    float2 sdx = dx;
	
    float3 sum = tex2D(sResampleMap, tx).rgb * 0.134598;
		
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.127325;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.107778;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.081638;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.055335;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.033562;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx).rgb)* 0.018216;
    sdx += dx;
    sum += (tex2D(sResampleMap, tx + sdx).rgb + tex2D(sResampleMap, tx - sdx ).rgb)* 0.008847;
    sdx += dx;
    
    return float4(sum, 1.0);
}

float4 StarLine(const vAP_Output v): COLOR0{
	float3 sum = float3(0.0, 0.0, 0.0);
	for(int i = 0; i < 8; i++)	
		sum += clamp(tex2D(sResampleMap, v.vTexCoords.xy + offsets[i]) - 0.7, 0.0, 10.0) * weights[i];
	for(int i = 0; i < 8; i++)	
		sum += clamp(tex2D(sResampleMap, v.vTexCoords.xy - offsets[i]) - 0.7, 0.0, 10.0) * weights[i];
		
	return float4(sum / 1.0, 1.0);
		
}

float4 Merge(const vAP_Output v): COLOR0{
	float3 sum = float3(0.0, 0.0, 0.0);
	float2 uv = v.vTexCoords.xy;
	
	sum += tex2D(sStarMap0, uv).rgb;
	sum += tex2D(sStarMap1, uv).rgb;
	sum += tex2D(sStarMap2, uv).rgb;
	sum += tex2D(sStarMap3, uv).rgb;
	
	sum *= 0.25;
	
	return float4(sum, 1.0);
}

float4 Merge6(const vAP_Output v): COLOR0{
	float3 sum = float3(0.0, 0.0, 0.0);
	float2 uv = v.vTexCoords.xy;
	
	sum += tex2D(sStarMap0, uv).rgb;
	sum += tex2D(sStarMap1, uv).rgb;
	sum += tex2D(sStarMap2, uv).rgb;
	sum += tex2D(sStarMap3, uv).rgb;
	sum += tex2D(sStarMap4, uv).rgb;
	sum += tex2D(sStarMap5, uv).rgb;
	
	sum /= 6.0;
	
	return float4(sum, 1.0);
}

float4 ClampResample1x1(const vAP_Output v): COLOR0{

	float3 diffuse = tex2D(sResampleMap, v.vTexCoords.xy).rgb;
	//float3 lum = tex2D(sAdaptAvgMap, float2(0.5, 0.5)).rgb;
	
#ifdef HARD	
	float l = dot(diffuse, LUM);
	float OV = overcast > 0.6 ? 1 : 0;
	if(l < 3.0)  diffuse = float3(0, 0, 0);
#endif

#ifdef NORMAL	
	float l = dot(diffuse, LUM);
	float OV = overcast > 0.6 ? 1 : 0;
	if(l < 3.0)  diffuse = float3(0, 0, 0);
#endif

#ifdef SOFT	
	float l = dot(diffuse, LUM);
	if(l < 0.0)  diffuse = float3(0, 0, 0);
#endif
	
	return float4(diffuse, 1.0);
	
}

technique FinalPass{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
        PixelShader  = compile ps_3_0 psMain(); 
	}
}

technique ResampleScene{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
        PixelShader  = compile ps_3_0 ResampleScene4x4();
	}
}

technique ResampleToLum{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
        PixelShader  = compile ps_3_0 ResampleToLum4x4();
	}
}

technique ResampleLum{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
        PixelShader  = compile ps_3_0 ResampleLum4x4();
	}
}

technique ResampleLum2{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
        PixelShader  = compile ps_3_0 ResampleLum2x2();
	}
}

technique Adaptation{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
		PixelShader  = compile ps_3_0 AdaptationPS();
	}
}

technique ClampResample{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
		PixelShader  = compile ps_3_0 ClampResample1x1();
	}
}

technique BlurX{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
		PixelShader  = compile ps_3_0 BlurX_gauss();
	}
}

technique BlurY{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
		PixelShader  = compile ps_3_0 BlurY_gauss();
	}
}

technique FakeHDR{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
		PixelShader = compile ps_3_0 FakeHDRPass();
	}
}

technique Star{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
		PixelShader = compile ps_3_0 StarLine();
	}
}

technique MergePass{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
		PixelShader = compile ps_3_0 Merge();
	}
}

technique MergePass6{
	pass P0{
		CULLMODE = NONE;	
		ZWRITEENABLE = 0x0;
		ZENABLE = 0x0;
		CLIPPLANEENABLE = 0x0;
		AlphaBlendEnable = 0x0;
		StencilEnable = false;
		
		VertexShader = compile vs_3_0 vsMain();
		PixelShader = compile ps_3_0 Merge6();
	}
}
